/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos;
    protected int count;

    public CharArrayReader(char[] cArray) {
        this.buf = cArray;
        this.pos = 0;
        this.count = cArray.length;
    }

    public CharArrayReader(char[] cArray, int n, int n2) {
        this.buf = cArray;
        this.pos = n;
        this.count = Math.min(n + n2, cArray.length);
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos >= this.count) {
                int n = -1;
                Object var3_4 = null;
                return n;
            }
            char c = this.buf[this.pos++];
            Object var3_5 = null;
            return c;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + n2 > this.count) {
                n2 = this.count - this.pos;
            }
            if (n2 <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, this.pos, cArray, n, n2);
            this.pos += n2;
            return n2;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if ((long)this.pos + l > (long)this.count) {
                l = this.count - this.pos;
            }
            if (l < 0L) {
                long l2 = 0L;
                Object var6_5 = null;
                return l2;
            }
            this.pos = (int)((long)this.pos + l);
            long l3 = l;
            Object var6_6 = null;
            return l3;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean bl = this.count - this.pos > 0;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.markedPos = this.pos;
            return;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.pos = this.markedPos;
            return;
        }
    }

    public void close() {
        this.buf = null;
    }
}

