/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;

class EmptyArgumentsProvider
implements ArgumentsProvider {
    EmptyArgumentsProvider() {
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        Method testMethod = context.getRequiredTestMethod();
        Class<?>[] parameterTypes = testMethod.getParameterTypes();
        Preconditions.condition(parameterTypes.length > 0, () -> String.format("@EmptySource cannot provide an empty argument to method [%s]: the method does not declare any formal parameters.", testMethod.toGenericString()));
        Class<?> parameterType = parameterTypes[0];
        if (String.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(""));
        }
        if (List.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptyList()));
        }
        if (Set.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptySet()));
        }
        if (Map.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptyMap()));
        }
        if (parameterType.isArray()) {
            Object array = Array.newInstance(parameterType.getComponentType(), 0);
            return Stream.of(Arguments.arguments(array));
        }
        throw new PreconditionViolationException(String.format("@EmptySource cannot provide an empty argument to method [%s]: [%s] is not a supported type.", testMethod.toGenericString(), parameterType.getName()));
    }
}

