package swing.layout;

import swing.common.TitledPanel;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;

public class GridBagLayoutPane extends JPanel implements ActionListener {
	private final GridBagLayout layout = new GridBagLayout();
	private GridBagConstraints c = new GridBagConstraints();
	
	private final JPanel panel = new JPanel(layout); 
	
	private JComponent selected;
	private Border border;
	
    final Map<String, Integer> fillMap = new HashMap<>();
    final JComboBox<String> fill = new JComboBox<>(new String[]{"NONE", "HORIZONTAL", "VERTICAL", "BOTH"});
    
    final Map<String, Integer> anchorMap = new HashMap<>();
    final JComboBox<String> anchor = new JComboBox<>(new String[]{"CENTER", "PAGE_START", "PAGE_END", "LINE_START", "LINE_END", "FIRST_LINE_START", "FIRST_LINE_END", "LAST_LINE_START", "LAST_LINE_END"});
    
    final JSlider ipadx = new JSlider(0, 20);
    final JSlider ipady = new JSlider(0, 20);
    final JSlider gridx = new JSlider(-1, 10);
    final JSlider gridy = new JSlider(-1, 10);
    final JSlider gridw = new JSlider(1, 5);
    final JSlider gridh = new JSlider(1, 5);
    final JSlider weightx = new JSlider(0, 10);
    final JSlider weighty = new JSlider(0, 10);
    
	public GridBagLayoutPane() {
		super(new BorderLayout());
		
		add(createLayoutPanel(), BorderLayout.CENTER);
		add(createControlPanel(), BorderLayout.PAGE_END);
		
	}

	private JComponent createLayoutPanel() {
		final GridBagConstraints c = new GridBagConstraints();
		
		c.fill = GridBagConstraints.BOTH;
        c.gridwidth = 2;
        createButton("Button 1", c);
		
        c.gridwidth = GridBagConstraints.REMAINDER;
        createButton("Button 2", c);
        
        c.gridwidth = 1;
        c.gridheight = 2;
        createButton("Button 3", c);
        c.gridheight = 1;
        createButton("Button 4", c);
        c.gridwidth = GridBagConstraints.REMAINDER;
        createButton("Button 5", c);
		
        c.gridwidth = 1;
        createButton("Button 6", c);
        createButton("Button 7", c);
		
		return new TitledPanel("Layout panel", panel);
	}
	
	private void createButton(final String title, final GridBagConstraints c) {
		final JButton button = new JButton(title);
		button.addActionListener(this);
		panel.add(button, c);
		
		if (selected == null) {
			select(button);
		}
	}
	
	private void setLabels(final JSlider slider) {
        slider.setLabelTable(slider.createStandardLabels(1));
        slider.setPaintLabels(true);
	}
	
	private JComponent createControlPanel() {
		final ControlPanel controlPanel = new ControlPanel();
		
        fillMap.put("NONE", GridBagConstraints.NONE);
        fillMap.put("HORIZONTAL", GridBagConstraints.HORIZONTAL);
        fillMap.put("VERTICAL", GridBagConstraints.VERTICAL);
        fillMap.put("BOTH", GridBagConstraints.BOTH);
        
        fill.addActionListener(e -> {
            c.fill = fillMap.get(fill.getSelectedItem());
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
		
        anchorMap.put("CENTER", GridBagConstraints.CENTER);
        anchorMap.put("PAGE_START", GridBagConstraints.PAGE_START);
        anchorMap.put("PAGE_END", GridBagConstraints.PAGE_END);
        anchorMap.put("LINE_START", GridBagConstraints.LINE_START);
        anchorMap.put("LINE_END", GridBagConstraints.LINE_END);
        anchorMap.put("FIRST_LINE_START", GridBagConstraints.FIRST_LINE_START);
        anchorMap.put("FIRST_LINE_END", GridBagConstraints.FIRST_LINE_END);
        anchorMap.put("LAST_LINE_START", GridBagConstraints.LAST_LINE_START);
        anchorMap.put("LAST_LINE_END", GridBagConstraints.LAST_LINE_END);
        
        anchor.addActionListener(e -> {
            c.anchor = anchorMap.get(anchor.getSelectedItem());
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
		
        ipadx.addChangeListener(e -> {
            c.ipadx = ipadx.getValue();
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
        setLabels(ipadx);
		
        ipady.addChangeListener(e -> {
            c.ipady = ipady.getValue();
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
        setLabels(ipady);
		
        gridx.addChangeListener(e -> {
            c.gridx = gridx.getValue();
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
        setLabels(gridx);
		
        gridy.addChangeListener(e -> {
            c.gridy = gridy.getValue();
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
        setLabels(gridy);
		
        gridw.addChangeListener(e -> {
            c.gridwidth = gridw.getValue();
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
        setLabels(gridw);
		
        gridh.addChangeListener(e -> {
            c.gridheight = gridh.getValue();
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
        setLabels(gridh);
        
        weightx.addChangeListener(e -> {
            c.weightx = weightx.getValue() / 100.0;
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
        setLabels(weightx);
        
        weighty.addChangeListener(e -> {
            c.weighty = weighty.getValue() / 100.0;
            layout.setConstraints(selected, c);
            panel.doLayout();
        });
        setLabels(weighty);
        
		controlPanel.add("fill", ' ', fill);
		controlPanel.add("anchor", ' ', anchor);
		controlPanel.add("ipadx", ' ', ipadx);
		controlPanel.add("ipady", ' ', ipady);
		controlPanel.add("gridx", ' ', gridx);
		controlPanel.add("gridy", ' ', gridy);
		controlPanel.add("gridwidth", ' ', gridw);
		controlPanel.add("gridheight", ' ', gridh);
		controlPanel.add("weightx", ' ', weightx);
		controlPanel.add("weighty", ' ', weighty);
		
		return new TitledPanel("Control panel", controlPanel);
	}
	
	private void updateSelection() {
		for (final Map.Entry<String, Integer> entry : fillMap.entrySet()) {
			if (entry.getValue() == c.fill) {
				fill.setSelectedItem(entry.getKey());
			}
		}
		for (final Map.Entry<String, Integer> entry : anchorMap.entrySet()) {
			if (entry.getValue() == c.anchor) {
				anchor.setSelectedItem(entry.getKey());
			}
		}
		ipadx.setValue(c.ipadx);
		ipady.setValue(c.ipady);
		gridx.setValue(c.gridx);
		gridy.setValue(c.gridy);
		gridw.setValue(c.gridwidth);
		gridh.setValue(c.gridheight);
		weightx.setValue((int) (c.weightx * 100));
		weighty.setValue((int) (c.weighty * 100));
	}

	public void actionPerformed(final ActionEvent e) {
		final Object source = e.getSource();
		if (source instanceof JComponent) {
			select((JComponent) source);
		}
	}
	
	private void select(final JComponent component) {
		if (selected != null) {
			selected.setBorder(border);
		}
		
		selected = component;
		c = layout.getConstraints(selected);
		border = selected.getBorder(); 
		selected.setBorder(BorderFactory.createCompoundBorder(
				BorderFactory.createLineBorder(Color.BLACK, 1),
				border
		));
		updateSelection();
	}
}
