package swing.button;

import swing.common.Demo;
import swing.common.Toolkit;

import javax.swing.*;
import java.awt.*;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

public class ButtonDemo extends Demo {
    public ButtonDemo() {
        super("ButtonDemo");
        
        setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));

        setJMenuBar(createMainMenu());
        add(createButtonPanel());
        add(createToggleButtonPanel());
        add(createCheckBoxPanel());
        add(createRadioButtonPanel());
        add(createButtonGroupPanel());
        add(createShortcutPanel());
    }

    private JPanel createTitledPanel(final JPanel panel, final String title) {
        final JPanel result = new JPanel(new BorderLayout());
        result.add(panel);
        result.setBorder(BorderFactory.createTitledBorder(
            BorderFactory.createEtchedBorder(),
            title
        ));
        return result;
    }

    private JComponent createButtonPanel() {
        final JPanel panel = new JPanel(new FlowLayout());

        final JButton ordinaryButton = new JButton("Ordinary button");
        final JButton disabledButton = new JButton("Disabled button");
        final JButton pressedButton = new JButton("Pressed button");
        final JButton defaultButton = new JButton("Default button");
        ordinaryButton.getInputMap().put(
            KeyStroke.getKeyStroke(KeyEvent.VK_T, InputEvent.CTRL_DOWN_MASK),
            "gotoText"
        );
        ordinaryButton.getActionMap().setParent(getRootPane().getActionMap());
        disabledButton.setEnabled(false);

        final ImageIcon icon = Toolkit.loadIcon("/toolbarButtonGraphics/general/Help16.gif");
        final JButton leftIconButton = new JButton("Left icon button", icon);
        final JButton rightIconButton = new JButton("Right icon button", icon);
        final JButton topIconButton = new JButton("Top icon button", icon);
        rightIconButton.setHorizontalTextPosition(JButton.LEFT);
        topIconButton.setVerticalTextPosition(JButton.BOTTOM);
        topIconButton.setHorizontalTextPosition(AbstractButton.CENTER);

        panel.add(ordinaryButton);
        panel.add(disabledButton);
        panel.add(pressedButton);
        panel.add(defaultButton);

        panel.add(leftIconButton);
        panel.add(rightIconButton);
        panel.add(topIconButton);

        getRootPane().setDefaultButton(defaultButton);

        return createTitledPanel(panel, "JButton");
    }

    private JComponent createToggleButtonPanel() {
        final JPanel panel = new JPanel(new FlowLayout());

        final JToggleButton ordinaryToggleButton = new JToggleButton("Ordinary toggle button");
        final JToggleButton selectedToggleButton = new JToggleButton("Selected toggle button", true);
        final JToggleButton disabledToggleButton = new JToggleButton("Disabled toggle button");
        final JToggleButton pressedToggleButton = new JToggleButton("Pressed toggle button");
        disabledToggleButton.setEnabled(false);

        panel.add(ordinaryToggleButton);
        panel.add(selectedToggleButton);
        panel.add(disabledToggleButton);
        panel.add(pressedToggleButton);

        return createTitledPanel(panel, "JToggleButton");
    }
    
    private JComponent createCheckBoxPanel() {
        final JPanel panel = new JPanel(new FlowLayout());

        final JCheckBox ordinaryCheckBox = new JCheckBox("Ordinary check box");
        final JCheckBox selectedCheckBox = new JCheckBox("Selected check box", true);
        final JCheckBox disabledCheckBox = new JCheckBox("Disabled check box");
        final JCheckBox pressedCheckBox = new JCheckBox("Pressed check box");
        disabledCheckBox.setEnabled(false);

        panel.add(ordinaryCheckBox);
        panel.add(selectedCheckBox);
        panel.add(disabledCheckBox);
        panel.add(pressedCheckBox);

        return createTitledPanel(panel, "JCheckBox");
    }

    private JComponent createRadioButtonPanel() {
        final JPanel panel = new JPanel(new FlowLayout());

        final JRadioButton ordinaryRadioButton = new JRadioButton("Ordinary radio button");
        final JRadioButton selectedRadioButton = new JRadioButton("Selected radio button", true);
        final JRadioButton disabledRadioButton = new JRadioButton("Disabled radio button");
        final JRadioButton pressedRadioButton = new JRadioButton("Pressed radio button");
        disabledRadioButton.setEnabled(false);

        panel.add(ordinaryRadioButton);
        panel.add(selectedRadioButton);
        panel.add(disabledRadioButton);
        panel.add(pressedRadioButton);

        return createTitledPanel(panel, "JRadioButton");
    }


    private JComponent createButtonGroupPanel() {
        final JPanel panel = new JPanel(new FlowLayout());

        final ButtonGroup group = new ButtonGroup();

        final JCheckBox checkBox = new JCheckBox("Check Box");
        final JRadioButton radioButton = new JRadioButton("Radio button");
        final JToggleButton toggleButton = new JToggleButton("Toggle button");
        final JButton button = new JButton("Button");

        panel.add(checkBox);
        panel.add(radioButton);
        panel.add(toggleButton);
        panel.add(button);

        group.add(checkBox);
        group.add(radioButton);
        group.add(toggleButton);
        group.add(button);

        return createTitledPanel(panel, "ButtonGroup");
    }

    private JComponent createShortcutPanel() {
        final JPanel panel = new JPanel(new FlowLayout());

        final JButton leftButton = new JButton("Left button");
        leftButton.setMnemonic(KeyEvent.VK_L);

        final JButton middleButton = new JButton("Middle button");
        middleButton.setMnemonic(KeyEvent.VK_B);

        final JButton rightButton = new JButton("Right button");
        rightButton.setMnemonic(KeyEvent.VK_N);

        panel.add(leftButton);
        panel.add(middleButton);
        panel.add(rightButton);

        final JTextField textField = new JTextField("Sample text");
        final JLabel fieldLabel = new JLabel("Text field");
        fieldLabel.setLabelFor(textField);
        fieldLabel.setDisplayedMnemonic(KeyEvent.VK_T);
        panel.add(fieldLabel);
        panel.add(textField);

        return createTitledPanel(panel, "Accelerators");
    }

    public static void main(final String[] args) {
        new ButtonDemo().setVisible(true);
    }
}

