package reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
public final class TestExample {
    public static void main(final String... args) {
        final Class<?> tested = ExampleTest.class;

        for (final Method method : tested.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Test.class)) {
                System.out.printf("Skipping non-test method %s%n", method);
                continue;
            }

            if (!Modifier.isStatic(method.getModifiers())) {
                System.out.printf("Test method %s is not static%n", method);
                continue;
            }

            if (method.getParameterCount() != 0) {
                System.out.printf("Test method %s has arguments%n", method);
                continue;
            }

            if (!method.canAccess(null) ) {
                System.out.printf("Test method %s in inaccessible%n", method);
                continue;
            }

            try {
                System.out.printf("Running test method %s%n", method);
                method.invoke(null);
                System.out.printf("\tTest %s success%n", method);
            } catch (final InvocationTargetException e) {
                System.out.printf("\tTest %s failed: %s%n", method, e.getCause());
            } catch (final IllegalAccessException e) {
                throw new AssertionError(e);
            }
        }
    }
}
