package reflection;

import java.lang.reflect.*;

/**
 * Simple {@link Proxy}-based profiler.
 */
public class Profiler implements InvocationHandler {
    /**
     * Proxy instance.
     */
    private final Object instance;

    /**
     * Proxied instance.
     */
    private final Object implementation;

    public Profiler(final Class[] interfaces, final Object implementation) {
        this.implementation = implementation;
        instance = Proxy.newProxyInstance(null, interfaces, this);
    }

    /**
     * Returns profiled instance.
     *
     * @return proxy instance with profiling capabilities.
     */
    public Object getInstance() {
        return instance;
    }

    @Override
    public Object invoke(final Object proxy, final Method method, final Object[] args)
        throws IllegalAccessException, InvocationTargetException
    {
        System.out.println("Calling " + method + " on " + implementation);
        return method.invoke(implementation, args);
    }
}
