package examples.net.udp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: geo
 * Date: 28.04.2010
 * Time: 7:54:13
 * To change this template use File | Settings | File Templates.
 */
public class DNS {
    public static byte[] createQuery(final int id, final String domain, final int type) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try {
                final DataOutputStream dos = new DataOutputStream(baos);
                try {
                    writeHeader(id, 0, 1, dos);
                    writeQuery(dos, domain, type, 1);
                } finally {
                    dos.close();
                }
            } finally {
                baos.close();
            }
            return baos.toByteArray();
        } catch (IOException e) {
            throw new AssertionError(e);
        }
    }

    private static void writeQuery(final DataOutputStream dos, final String domain, final int type, final int clazz) throws IOException {
        // QNAME
        final String[] labels = domain.split("\\.");
        for (String label : labels) {
            writeLabel(dos, label);
        }
        writeLabel(dos, "");

        dos.writeShort(type); // QTYPE
        dos.writeShort(clazz); // QCLASS
    }

    private static void writeLabel(final DataOutputStream dos, final String label) throws IOException {
        final byte[] bytes = label.getBytes("US-ASCII");
        dos.writeByte(bytes.length);
        dos.write(bytes);
    }

    private static void writeHeader(final int id, final int header, final int questionCount, final DataOutputStream dos)
            throws IOException {
        dos.writeShort(id); // ID
        dos.writeShort(header); // Header fields
        dos.writeShort(questionCount); // QDCOUNT
        dos.writeShort(0); // ANCOUNT
        dos.writeShort(0); // NSCOUNT
        dos.writeShort(0); // ARCOUNT
    }
}
