package net;

import java.net.*;
import java.io.*;

public class HelloClient {
    private final static int SERVER_PORT = 12345;

    public static void main(final String... args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: HelloClient <user name>");
            return;
        }

        try (Socket socket = new Socket("localhost", SERVER_PORT)) {
            final DataOutput dos = new DataOutputStream(socket.getOutputStream());
            dos.writeUTF(args[0]);
            socket.shutdownOutput();

            final DataInput dis = new DataInputStream(socket.getInputStream());
            final String message = dis.readUTF();
            System.out.println(message);
        }
    }
}
