package net;

import java.net.*;
import java.io.*;

public enum FTP {
    ;

    public static void main(final String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: FTP <host> <file> <user> <password>");
            return;
        }
        final String host = args[0];
        final String file = args[1];
        final String user = args[2];
        final String password = args[3];

        final URL url = new URI("ftp://" + user + ":" + password + "@" + host + file).toURL();
        System.out.println("Getting " + url);

        final URLConnection connection = url.openConnection();
        connection.connect();
        final InputStream is = connection.getInputStream();
        int c;
        while ((c = is.read()) != -1) {
            System.out.print((char) c);
        }
    }
}