package io;

import java.io.*;

/**
 * Converts {@code input.txt} from <em>Cp1251</em> to <em>Cp866</em>
 * encoding and writes result to the {@code output.txt} file.
 * <p>
 * <b>Warning: This code violates exception handling principles.</b>
 * For correct version see {@link FullEncodingConverter}.
 *
 * @author Georgiy Korneev
 */
public final class EncodingConverter {
    /**
     * Converts {@code input.txt} from <em>Cp1251</em> to <em>Cp866</em>
     * encoding and writes result to the {@code output.txt} file.
     * <p>
     * <em>Warning: This code violates exception handling principles.</em>
     *
     * @param args ignored.
     *
     * @throws IOException if an I/O error occurred.
     */
    public static void main(final String[] args) throws IOException {
         final Reader reader =
            new InputStreamReader(new FileInputStream("input.txt"), "Cp1251");
         final Writer writer =
            new OutputStreamWriter(new FileOutputStream("output.txt"), "Cp866");
         int c;
         while ((c = reader.read()) >= 0) {
             writer.write(c);
         }
         reader.close();
         writer.close();
    }
}
