package i18n;

import java.util.*;

public enum Usage {
    ;

    private static void printUsage(final ResourceBundle bundle) {
        System.out.printf(
                """
                        %s Test [%s] %s
                        %s
                             -o %s
                        ...%n
                """,
                bundle.getString("usage"),// Usage:
                bundle.getString("options"),// <options>
                bundle.getString("commands"),// <commands>
                bundle.getString("Options"),// Options:
                bundle.getString("-o")// Write output
        );
    }
    public static void main(final String[] args) {
        final Locale locale = getLocale(args);

        final ResourceBundle bundle =
            ResourceBundle.getBundle("i18n.UsageResourceBundle", locale);
        printUsage(bundle);
    }

    @SuppressWarnings("deprecated")
    private static Locale getLocale(final String[] args) {
        return switch (args.length) {
            case 0 -> Locale.getDefault();
// Java 19+
            case 1 -> Locale.of(args[0]);
            case 2 -> Locale.of(args[0], args[1]);
            default -> Locale.of(args[0], args[1], args[2]);
// Java 19-
//            case 1 -> new Locale(args[0]);
//            case 2 -> new Locale(args[0], args[1]);
//            default -> new Locale(args[0], args[1], args[2]);
        };
    }
}
