package i18n;

import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
public final class CollationDemo {
    public static void main(final String[] args) {
        final List<String> words = List.of("peach", "péché", "pêche", "peaches");
        for (final Locale locale : Collator.getAvailableLocales()) {
            final Collator collator = Collator.getInstance(locale);
            collator.setStrength(Collator.PRIMARY);
            final String sorted = words.stream().sorted(collator).collect(Collectors.joining(", "));
            System.out.printf("%40s: %s%n", locale.getDisplayName(), sorted);
        }
    }
}
